<?php

function child_theme_enqueue_styles() {

 	wp_enqueue_style( 'divi-style', get_template_directory_uri() . '/style.css' );

    wp_enqueue_style( 

		'child-style', 

		get_stylesheet_directory_uri() . '/style.css', 

		array( 'divi-style' ), 

		filemtime(get_stylesheet_directory() . '/style.css')

	);

}

add_action( 'wp_enqueue_scripts', 'child_theme_enqueue_styles' );



function rtl_child_theme_enqueue_styles() {

	if ( is_rtl() ) {

		// Add custom google font - for Arabic version of the website

		wp_enqueue_style('custom-google-fonts', 'https://fonts.googleapis.com/css?family=Cairo', false);

		wp_enqueue_style( 

			'rtl-child-style', 

			get_stylesheet_directory_uri() . '/rtl-child-style.css', 

			array( 'divi-style' ), 

			filemtime(get_stylesheet_directory() . '/rtl-child-style.css')

		);		

	}

}

add_action('wp_enqueue_scripts', 'rtl_child_theme_enqueue_styles');



/** Add polylang to Divi Library Window */



add_filter('pll_get_post_types', 'my_pll_get_post_types');

function my_pll_get_post_types($types) {

	return array_merge($types, array('et_pb_layout' => 'et_pb_layout'));

}

function create_meta_desc() {
 global $post;
if (!is_singular()) {return; }
elseif(!empty( $post->post_excerpt)) {
echo "<meta name='description' content='$post->post_excerpt' />";
} else {                                   
  echo "<meta name='description' content='$post->post_title' />";
} } 

add_action('wp_head', 'create_meta_desc');